
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */

/**
 * Representa um inimigo
 */
public class Enemy extends GameObject {

    /** Indica se o inimigo est explodindo */
    private boolean isBlown = false;

    /** Indica se o inimigo est morto */
    private boolean dead = false;

    /** Varivel usada para animar as imagens */
    private int tick;

    /** Array usado para sortear a velocidade x do inimigo na sua criao */
    private int[] velX = new int[]{-1,1};

    /**
     * Construtor
     * @param x, Posio x inicial
     * @param y, Posio y inicial
     * @param initialSequence Sequencia inicial que representam o inimigo
     * @param v, Se o inimigo est visvel ou no
     */
    public Enemy(int x, int y, int[] initialSequence, boolean v) {
        super(x, y, Constants.enemyImage, 
        		Constants.ENEMY_FRAME_WIDTH, Constants.ENEMY_FRAME_HEIGHT, 
        		initialSequence);
        int xvel = (Constants.random.nextInt()>>>1) % velX.length;
        this.setXspeed(velX[xvel]);
        this.setYspeed(3);
        this.setVisible(v);
    }

    /**
     * Retorna o valor em pontos do inimogo
     */
    public int getScore() {
        return 100;
    }

    /**
     * Indica se o inimigo est explodindo
     */
    public void setBlown(boolean isBlown) {
        this.isBlown = isBlown;
    }

    /**
     * Retorna se o inimigo est explodindo
     */
    public boolean isBlown() {
        return isBlown;
    }
    
    /* ************************************************************
     * O frame a ser rederizado  controlado pelo frame sequence.
     * Assim, no  necessrio redefinir o a lgica de pintura, 
     * isto , o mtodo paint(Graphics).
     * ************************************************************/

    /**
     * Atualiza a posio sdo inimigo
     */
    public void update() {
        // atualiza o tick
        tick = tick < 10 ? tick + 1 : 0;

        if(this.isVisible()) {
        	// atualiza posio do inimigo de acordo com velocidades
        	super.applySpeed();

            //caso saiu da tela,  randomizado uma nova posio
            if(this.getY() > Constants.HEIGHT) {
                this.randomize();
            }
        }

        // Controla os frames da animao
        // se est explodindo seta a imagem da exploso
        if(isBlown) {
            this.setFrameSequence(Constants.blowEnemySequence);
            //acabou a animao da exploso, o inimigo morreu
            if(tick == 9){
               this.dead = true;
            }
        }

        // anima as imagens baseado no tick
        if(tick < 5){
        	this.setFrame(0);
        }else{
        	this.setFrame(1);
        }
    }

    /**
     * Randomiza a posiao X,Y do inimigo
     */
    public void randomize(){
    	int x = (Constants.random.nextInt()>>>1)%(Constants.WIDTH - getWidth());
        int y = -getHeight() - ((Constants.random.nextInt()>>>1) % 10);
        this.setPosition(x, y);
    }

    /**
     * Retorna o estado do inimigo (morto ou no)
     */
    public boolean isDead(){
    	return dead;
    }

}
